﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja czasu pracy</title>
		<script runat="server">
		        
	   class Item {

           public Pracownik pracownik;
           public Pracownik Pracownik {
               get { return pracownik; }
           }
           
			readonly string nazwa;
			readonly public object[] items = new object[12];
			
			public Item(string nazwa) {
				this.nazwa = nazwa;
			}
			public void Set(int m, object value) {
				items[m-1] = value;
			}
			public string Nazwa {
				get { return nazwa; }
			}
			public object M1 {
				get { return items[0]; }
			}
			public object M2 {
				get { return items[1]; }
			}
			public object M3 {
				get { return items[2]; }
			}
			public object M4 {
				get { return items[3]; }
			}
			public object M5 {
				get { return items[4]; }
			}
			public object M6 {
				get { return items[5]; }
			}
			public object M7 {
				get { return items[6]; }
			}
			public object M8 {
				get { return items[7]; }
			}
			public object M9 {
				get { return items[8]; }
			}
			public object M10 {
				get { return items[9]; }
			}
			public object M11 {
				get { return items[10]; }
			}
			public object M12 {
				get { return items[11]; }
			}
			public virtual object MR { 
				get { return ""; }
			}
	   }
	   
	   class IntItem: Item {
			public IntItem(string nazwa): base(nazwa) {
				for (int i=0; i<12; i++)
					items[i] = 0;
			}
			public override object MR { 
				get {
					int razem = 0;
					foreach (int i in items)
						razem += i;
					return razem;
				}
			}
			public void Add(int m, int v) {
				items[m-1] = (int)items[m-1] + v;
			}
	   }
	   
	   class TimeItem: Item {
			public TimeItem(string nazwa): base(nazwa) {
				for (int i=0; i<12; i++)
					items[i] = Time.Zero;
			}
			public override object MR { 
				get {
					Time razem = Time.Zero;
					foreach (Time i in items)
						razem += i;
					return razem;
				}
			}
			public void Add(int m, Time t) {
				items[m-1] = (Time)items[m-1] + t;
			}
	   }

       class Item2 {
           
           private Date data;
           private Time w1;
           private Time w2;
           private Time w3;
           private Time w4;
           
           public Item2(Date data, Time w1, Time w2, Time w3, Time w4) {
               this.data = data;
               this.w1 = w1;
               this.w2 = w2;
               this.w3 = w3;
               this.w4 = w4;
           }
           
           public Date Data {
               get { return data; }
           }
           public Time W1 {
               get { return w1; }
           }
           public Time W2 {
               get { return w2; }
           }
           public Time W3 {
               get { return w3; }
           }
           public Time W4 {
               get { return w4; }
           }
       }
       	   
	   public class PrnParams: ContextBase {
	   
		   public PrnParams(Context context): base(context) {
			   Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			   okres = FromTo.Year(data.Year);
		   }
		   
		   FromTo okres;
		   [Required]
		   [Priority(1)]
		   public FromTo Okres {
			   get { return okres; }
			   set {
                   if (value != FromTo.Empty && value != FromTo.All)
				      okres = value;
				   OnChanged(EventArgs.Empty);
			   }
		   }

		   bool tylkoNiezbilansowane = false;
		   [Priority(2)]
		   [Caption("Tylko niezbilansowane")]
		   public bool TylkoNiezbilansowane {
			   get { return tylkoNiezbilansowane; }
			   set {
				   tylkoNiezbilansowane = value;
				   OnChanged(EventArgs.Empty);
			   }
		   }

           bool szczegolowo = false;
           [Priority(3)]
           [Caption("Pokaż szczegółowo dni")]
           public bool Szczegolowo {
               get { return szczegolowo; }
               set {
                   szczegolowo = value;
                   OnChanged(EventArgs.Empty);
               }
           }
	   }

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }

            //static bool infoOCzasiePracy = false;
            bool infoOCzasiePracy = false;
            [Priority(1)]
            [Caption("Info o czasie pracy")]
            public bool InfoOCzasiePracy {
                get { return infoOCzasiePracy; }
                set {
                    infoOCzasiePracy = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
		              
        PrnParams pars;
        [Context(Required=true)]
        public PrnParams Params {
            get { return pars; }
            set { pars = value; }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }		
		            
       void OnContextLoad(Object sender, EventArgs args) {
           if (pars.Okres == FromTo.Year(pars.Okres.From.Year))
               ReportHeader1["OKRES"] = pars.Okres.From.Year + " rok";
           else
               ReportHeader1["OKRES"] = pars.Okres.ToString();		
           ReportHeader1["NIEROZL"] = pars.TylkoNiezbilansowane ? "TAK" : "NIE";
	    }

        void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
            Pracownik pracownik = (Pracownik)DataRepeater1.CurrentRow;
            colPracownik.Caption = pracownik.ToString();
            ArrayList items = new ArrayList(WyliczPracownika(pracownik));
            Grid1.Visible = items.Count != 0;
            if (Grid1.Visible)
                Grid1.DataSource = items;
            Grid2.Visible = pars.Szczegolowo && Grid1.Visible;
            if (Grid2.Visible)
                Grid2.DataSource = new ArrayList(WyliczPracownikaDni(pracownik, ref items));
        }
            
		static readonly string prefix = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

        ArrayList WyliczPracownika(Pracownik pracownik) {
			ArrayList items1 = new ArrayList();
			
			IntItem normaD = new IntItem("Normatywny czas pracy - dni");
			TimeItem normaT = new TimeItem(prefix + "- godziny");
			
			IntItem pracaD = new IntItem("Faktyczny czas pracy - dni");
			TimeItem pracaT = new TimeItem(prefix + "- godziny");

            if (srpars.InfoOCzasiePracy) {
                items1.Add(normaD);
                items1.Add(normaT);
                items1.Add(pracaD);
                items1.Add(pracaT);
            }
            
            TimeItem doPrzeniesienia = new TimeItem("Nadgodziny do przeniesienia");
            items1.Add(doPrzeniesienia);
            TimeItem zPrzeniesienia = new TimeItem(prefix + "- z przeniesienia");
            items1.Add(zPrzeniesienia);
            TimeItem przeniesienieWsp = new TimeItem(prefix + "- z przeniesienia (po uwzględnieniu współczynnika)");
            items1.Add(przeniesienieWsp);
            TimeItem przeniesienieSaldo = new TimeItem(prefix + "- saldo");
            items1.Add(przeniesienieSaldo);
           													
			Hashtable ht = new Hashtable();
									 
			FromTo okres = pars.Okres;
			Periods zatrud = Periods.Empty;
			Periods wgkalendarza = Periods.Empty;
           
			foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres)) {
				zatrud += ph.Etat.EfektywnyOkres;
				if (ph.Etat.InterpretacjaKalendarza!=InterpretacjaKalendarza.WgZestawien)
					wgkalendarza += ph.Etat.EfektywnyOkres;
			}
				
			zatrud = zatrud.ToFlat();
			zatrud *= okres;
			zatrud = zatrud.BreakByMonth();

            Soneta.Kalend._Pracownik.CzasPracyEtatWorker worker = new Soneta.Kalend._Pracownik.CzasPracyEtatWorker();
            worker.Pracownik = pracownik;
                
            foreach (FromTo okr in zatrud.BreakByMonth()) {
                worker.Okres = okr;
                int m = okr.From.Month;

                CzasDni norma = worker.Norma;
                normaD.Add(m, norma.Dni);
                normaT.Add(m, norma.Czas);

                CzasDni praca = worker.Praca;
                pracaD.Add(m, praca.Dni);
                pracaT.Add(m, praca.Czas);

                Time t1 = Time.Empty, t2 = Time.Empty;
                Soneta.Kalend._Pracownik.CzasPracyBaseWorker._Odchylka od = worker.Odchylka;
                if (wgkalendarza.Contains(okr)) {
                    Soneta.Kalend._Pracownik.CzasPracyBaseWorker.WgStrefLista sl = worker.WgStref;
                    t1 = sl["Rozliczenie wyjścia prywatnego"].Czas;
                    t2 = sl["Wyjście prywatne"].Czas;
                }
                Time w1 = od.ZPrzeniesienia != Time.Empty ? od.ZPrzeniesienia - (t2 != Time.Empty ? t2 : Time.Zero) : Time.Empty;  
                zPrzeniesienia.Add(m, w1);
                Time w2 = od.DoPrzeniesienia != Time.Empty ? od.DoPrzeniesienia - (t1 != Time.Empty ? t1 : Time.Zero) : Time.Empty;
                doPrzeniesienia.Add(m, w2);
                Time w3 = od.ZPrzeniesieniaWsp != Time.Empty ? od.ZPrzeniesieniaWsp - (t2 != Time.Empty ? t2 : Time.Zero) : Time.Empty;
                przeniesienieWsp.Add(m, w3);
                przeniesienieSaldo.Add(m, w2 - w3);
            }            			
            
            foreach (Item item1 in items1)
                item1.pracownik = pracownik;

            if (pars.TylkoNiezbilansowane && przeniesienieSaldo.MR.Equals(Time.Zero))
                items1.Clear();
            else if (zPrzeniesienia.MR.Equals(Time.Zero) && doPrzeniesienia.MR.Equals(Time.Zero) && przeniesienieWsp.MR.Equals(Time.Zero))
                items1.Clear();
           return items1;
       }

        ArrayList WyliczPracownikaDni(Pracownik pracownik, ref ArrayList items1) {
            ArrayList items2 = new ArrayList();

            if (items1.Count == 0)
                return items2;
            
            FromTo okres = pars.Okres;
            Periods zatrud = Periods.Empty;
            Periods wgkalendarza = Periods.Empty;

            foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres)) {
                zatrud += ph.Etat.EfektywnyOkres;
                if (ph.Etat.InterpretacjaKalendarza != InterpretacjaKalendarza.WgZestawien)
                    wgkalendarza += ph.Etat.EfektywnyOkres;
            }

            zatrud = zatrud.ToFlat();
            zatrud *= okres;
            zatrud = zatrud.BreakByMonth();

            Soneta.Kalend._Pracownik.CzasPracyEtatWorker worker = new Soneta.Kalend._Pracownik.CzasPracyEtatWorker();
            worker.Pracownik = pracownik;

            foreach (FromTo okr in zatrud.BreakByMonth()) {
                int m = okr.From.Month;
                int flaga = 0;
                foreach (Item item1 in items1) {
                    if (item1.Nazwa.Contains("Nadgodziny"))
                        flaga = 1;
                    if (flaga == 0)
                        continue;
                    if (item1 is TimeItem && (Time)item1.items[m - 1] != Time.Zero) {
                        flaga = 2;
                        break;
                    }
                }
                if (flaga != 2)
                    continue;
                foreach (Date dt in okr) {
                    worker.Okres = FromTo.Day(dt);
                    Time t1 = Time.Empty, t2 = Time.Empty;
                    Soneta.Kalend._Pracownik.CzasPracyBaseWorker._Odchylka od = worker.Odchylka;
                    if (wgkalendarza.Contains(worker.Okres)) {
                        Soneta.Kalend._Pracownik.CzasPracyBaseWorker.WgStrefLista sl = worker.WgStref;
                        t1 = sl["Rozliczenie wyjścia prywatnego"].Czas;
                        t2 = sl["Wyjście prywatne"].Czas;
                    }
                    Time w1 = od.ZPrzeniesienia != Time.Empty ? od.ZPrzeniesienia - (t2 != Time.Empty ? t2 : Time.Zero) : Time.Empty;
                    Time w2 = od.DoPrzeniesienia != Time.Empty ? od.DoPrzeniesienia - (t1 != Time.Empty ? t1 : Time.Zero) : Time.Empty;
                    Time w3 = od.ZPrzeniesieniaWsp != Time.Empty ? od.ZPrzeniesieniaWsp - (t2 != Time.Empty ? t2 : Time.Zero) : Time.Empty;
                    Time w4 = w2 - w3;
                    
                    if (pars.TylkoNiezbilansowane && w4.Equals(Time.Zero))
                        continue;
                    else if (w1.Equals(Time.Zero) && w2.Equals(Time.Zero) && w3.Equals(Time.Zero))
                        continue;

                    Item2 item2 = new Item2(dt, w1, w2, w3, w4);
                    items2.Add(item2);
                }
            }

            return items2;
        }
           
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="EwidencjaCzasuPracy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
				<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" 
				    title="Rozliczenie nadgodzin z przeniesienia&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Wydział:&lt;strong&gt; {0}&lt;BR&gt;&lt;/strong&gt;Pośrednio:&lt;strong&gt; {1}&lt;BR&gt;&lt;/strong&gt;Okres:&lt;strong&gt; {2}&lt;BR&gt;&lt;/strong&gt;Aktualny:&lt;strong&gt; {3}&lt;BR&gt;&lt;/strong&gt;Raport za okres:&lt;strong&gt; %OKRES%&lt;BR&gt;&lt;/strong&gt;Tylko niezbilansowane:&lt;strong&gt; %NIEROZL%&lt;/SPAN&gt;" 
                    DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                    DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                    DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                    DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny">
                </cc1:reportheader>
                <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.Pracownik, Soneta.KadryPlace"
                    Width="100%" OnBeforeRow="DataRepeater1_BeforeRow">
				    <ea:grid id="Grid1" runat="server" DataMember="DataSource">
					    <Columns>
						    <ea:GridColumn Width="30" DataMember="Nazwa" ID="colPracownik"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M1" Caption="I" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M2" Caption="II" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M3" Caption="III" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M4" Caption="IV" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M5" Caption="V" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M6" Caption="VI" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M7" Caption="VII" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M8" Caption="VIII" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M9" Caption="IX" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M10" Caption="X" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M11" Caption="XI" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Align="Right" DataMember="M12" Caption="XII" HideZero="True"></ea:GridColumn>
						    <ea:GridColumn Width="8" Align="Right" DataMember="MR" Caption="Razem" HideZero="True"></ea:GridColumn>
					    </Columns>
				    </ea:grid>
				    <ea:grid id="Grid2" runat="server" DataMember="DataSource">
					    <Columns>
						    <ea:GridColumn Width="12" Align="Right" DataMember="Data" Caption="Data" Total="Info"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="W2" Caption="Nadgodziny|do przeniesienia" Total="Sum"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="W1" Caption="Rozliczenie nadgodzin z przeniesienia~ " Total="Sum"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="W3" Caption="Rozliczenie nadgodzin z przeniesienia~(po uwzgl.współcz.)" Total="Sum"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="W4" Caption="Saldo" Total="Sum"></ea:GridColumn>
					    </Columns>
				    </ea:grid>
                    <br />
			    </ea:DataRepeater>
		</form>
	</body>
</HTML>
